<?php get_header(); ?>
<?php
$mc_location = defined('MOORES_LOCATION') ? MOORES_LOCATION : '';
$mc_phone = defined('MOORES_PHONE') ? MOORES_PHONE : '';
$mc_hours_weekdays = defined('MOORES_HOURS_WEEKDAYS') ? MOORES_HOURS_WEEKDAYS : '';
$mc_hours_saturday = defined('MOORES_HOURS_SATURDAY') ? MOORES_HOURS_SATURDAY : '';
?>

<section class="hero">
	<div class="container-wide hero-inner">
		<div class="hero-grid">
			<div>
				<div class="kicker">40 years of handcrafted artwork</div>
				<h1 class="hero-title">CUSTOM PAINT, AIRBRUSH & MURALS<br>BUILT ON 40 YEARS OF CRAFT.</h1>
				<p class="lead">
					From motorcycles and automotive builds to firearms and murals, every piece is finished with patience,
					precision, and durable clear systems.
				</p>

				<div class="hero-actions">
					<a class="btn btn-primary" href="<?php echo esc_url(function_exists('moores_request_quote_url') ? moores_request_quote_url() : home_url('/request-quote/')); ?>">Start a Project</a>
					<a class="btn btn-outline" href="#work">View Our Work</a>
				</div>
			</div>

			<div class="hero-meta">
				<div class="badge">📍 <?php echo esc_html($mc_location); ?></div>
				<div class="meta-row">
					<div class="badge">☎ <?php echo esc_html($mc_phone); ?></div>
					<div class="badge">Weekdays <?php echo esc_html($mc_hours_weekdays); ?></div>
					<div class="badge">Sat <?php echo esc_html($mc_hours_saturday); ?></div>
				</div>

				<div class="panel edge pad" style="width:100%;">
					<h3 style="margin-bottom:8px;">Legacy Driven Craft</h3>
					<p style="margin:0;">
						Self taught since age 12, refined on a 1969 Harley Davidson, and shaped by fine art commissions. That standard now
						powers every finish.
					</p>
				</div>
			</div>
		</div>

		<div style="margin-top: var(--sp-50);">
				<div class="strip">
					<div class="tile">
						<div class="label">Focus</div>
						<div class="value">Custom builds</div>
					</div>
					<div class="tile">
						<div class="label">Style</div>
						<div class="value">Airbrush + fine art</div>
					</div>
					<div class="tile">
						<div class="label">Protection</div>
						<div class="value">Show quality clears</div>
					</div>
					<div class="tile">
						<div class="label">Legacy</div>
						<div class="value">40+ years</div>
					</div>
				</div>
			</div>

	</div>
</section>

<section class="section" id="legacy">
	<div class="container-wide">
		<div class="kicker">Legacy</div>
		<h2>40 Years of Craft & Legacy</h2>

		<div class="panel edge pad mc-legacy-teaser" style="margin-top: var(--sp-20);">
			<p class="lead">
				Mastery isn't taught. It's earned. Self taught since age 12, refined on a 1969 Harley Davidson, and shaped by
				fine art commissions and global exhibitions, Moore's Customz is built on process and patience.
			</p>

			<div class="mc-legacy-timeline">
				<div class="mc-legacy-step">
					<div class="mc-legacy-year">1987</div>
					<div class="mc-legacy-copy">Months on a 1969 Harley Davidson forged a process first work ethic.</div>
				</div>
				<div class="mc-legacy-step">
					<div class="mc-legacy-year">Alabama + Tennessee</div>
					<div class="mc-legacy-copy">Professional representation led to major institutional commissions.</div>
				</div>
				<div class="mc-legacy-step">
					<div class="mc-legacy-year">Global Reach</div>
					<div class="mc-legacy-copy">Exhibited in Italy and Africa; featured in NYC galleries and international contests.</div>
				</div>
			</div>

			<div class="mc-legacy-actions">
				<a class="btn btn-outline" href="<?php echo esc_url(home_url('/legacy/')); ?>">Read the full legacy</a>
			</div>
		</div>
	</div>
</section>

<?php if (current_user_can('manage_options') && isset($_GET['sentra_debug'])) : ?>
	<?php $debug_data = function_exists('moores_sentra_debug_snapshot') ? moores_sentra_debug_snapshot() : ['error' => 'moores_sentra_debug_snapshot not available']; ?>
	<div class="container-wide" style="margin-top: var(--sp-30);">
		<pre style="white-space: pre-wrap; font-size: 12px; color: var(--muted); background: rgba(0,0,0,0.25); padding: 16px; border-radius: var(--r-s);">
<?php echo esc_html(wp_json_encode($debug_data, JSON_PRETTY_PRINT)); ?>
		</pre>
	</div>
<?php endif; ?>

<section class="section" id="services">
	<div class="container-wide">
		<div style="display:flex; justify-content:space-between; gap: var(--sp-30); align-items:flex-end; flex-wrap:wrap;">
			<div style="max-width: 820px;">
				<div class="kicker">Services</div>
				<h2>High detail finishes, built for real world use.</h2>
				<p class="lead">
					Every project starts with disciplined prep, then layered artwork, then a finish that can be handled, driven, or carried.
					This is show quality work that still holds up.
				</p>
			</div>
		</div>

		<?php $sentra_services = function_exists('moores_sentra_get_services') ? moores_sentra_get_services(12) : []; ?>
		<?php if (!empty($sentra_services)) : ?>
			<div style="margin-top: var(--sp-40);" class="cards">
				<?php foreach ($sentra_services as $service) : ?>
					<div class="card">
						<?php if (!empty($service['badge'])) : ?>
							<div class="badge" style="margin-bottom: 10px;"><?php echo esc_html($service['badge']); ?></div>
						<?php endif; ?>
						<h3><?php echo esc_html($service['title']); ?></h3>
						<?php if (!empty($service['description'])) : ?>
							<p><?php echo esc_html($service['description']); ?></p>
						<?php endif; ?>
					</div>
				<?php endforeach; ?>
			</div>
		<?php else : ?>
			<p class="lead" style="margin-top: var(--sp-40);">Service details are being refreshed. Contact us for availability.</p>
		<?php endif; ?>
	</div>
</section>

<section class="section-tight" id="work">
	<div class="container-wide">
		<div class="kicker">Work</div>
		<h2>Featured builds, process stages, and final finishes.</h2>
		<p class="lead" style="margin-top: var(--sp-10);">
			We document the process, not just the final shine, so you can see the craft at every stage.
		</p>
		<?php
		$gallery_items = function_exists('moores_sentra_get_gallery_items') ? moores_sentra_get_gallery_items(80, null) : [];
		$mc_is_video = function($item) {
			if (!is_array($item)) return false;
			$meta = [];
			if (!empty($item['metadata'])) {
				$meta = is_array($item['metadata']) ? $item['metadata'] : json_decode((string) $item['metadata'], true);
			}
			if (is_array($meta)) {
				foreach (['type', 'media_type', 'content_type', 'mime', 'mime_type'] as $key) {
					if (!empty($meta[$key]) && stripos((string) $meta[$key], 'video') !== false) {
						return true;
					}
				}
			}
			$src = (string) ($item['src'] ?? '');
			if ($src === '') return false;
			$path = parse_url($src, PHP_URL_PATH);
			$ext = strtolower(pathinfo($path ?: $src, PATHINFO_EXTENSION));
			return in_array($ext, ['mp4', 'webm', 'mov', 'm4v', 'ogv'], true);
		};
		$job_cards = [];
		$jobs_payload = [];
		if (!empty($gallery_items)) {
			$final_keywords = ['final', 'finish', 'finished', 'complete', 'completed', 'delivery', 'delivered', 'done'];
			$match_final = function($item) use ($final_keywords) {
				if (!is_array($item)) return false;
				if (!empty($item['metadata']) && is_array($item['metadata'])) {
					if (!empty($item['metadata']['final']) || !empty($item['metadata']['is_final']) || !empty($item['metadata']['isFinal'])) {
						return true;
					}
				}
				$raw = strtolower(trim((string) ($item['process'] ?? '')));
				if ($raw === '') return false;
				foreach ($final_keywords as $word) {
					if (strpos($raw, $word) !== false) return true;
				}
				return false;
			};

			$jobs = [];
			foreach ($gallery_items as $index => $item) {
				$job_id = isset($item['job_id']) ? trim((string) $item['job_id']) : '';
				$key = $job_id !== '' ? 'job-' . $job_id : 'item-' . $index;
				if (!isset($jobs[$key])) {
					$jobs[$key] = [
						'key' => $key,
						'job_id' => $job_id,
						'items' => [],
					];
				}
				$jobs[$key]['items'][] = $item;
			}

			foreach ($jobs as $job) {
				$items = $job['items'];
				if (function_exists('moores_sentra_sort_gallery_items')) {
					$items = moores_sentra_sort_gallery_items($items);
				}
				$cover = null;
				$is_job_featured = false;
				$job_featured_seen = false;
				$item_featured = false;
				foreach ($items as $candidate) {
					$featured_flag = function_exists('moores_sentra_flag_truthy')
						? moores_sentra_flag_truthy($candidate['is_featured'] ?? false)
						: !empty($candidate['is_featured']);
					if ($featured_flag) $item_featured = true;
					if (array_key_exists('job_featured', $candidate) && $candidate['job_featured'] !== null) {
						$job_featured_seen = true;
						if ($candidate['job_featured']) $is_job_featured = true;
					}
					if (!$cover && $match_final($candidate)) {
						$cover = $candidate;
					}
				}
				if (!$job_featured_seen && $item_featured) {
					$is_job_featured = true;
				}
				if (!$cover) {
					foreach ($items as $candidate) {
						$featured_flag = function_exists('moores_sentra_flag_truthy')
							? moores_sentra_flag_truthy($candidate['is_featured'] ?? false)
							: !empty($candidate['is_featured']);
						if ($featured_flag) {
							$cover = $candidate;
							break;
						}
					}
				}
				if (!$cover) $cover = $items[0] ?? null;
				if (!$cover) continue;
				$cover_is_video = $mc_is_video($cover);

				$job_cards[] = [
					'key' => $job['key'],
					'job_id' => $job['job_id'],
					'cover' => $cover,
					'items' => $items,
					'is_featured' => $is_job_featured,
					'cover_is_video' => $cover_is_video,
				];
			}

			usort($job_cards, function($a, $b) {
				$a_featured = !empty($a['is_featured']);
				$b_featured = !empty($b['is_featured']);
				if ($a_featured !== $b_featured) return $a_featured ? -1 : 1;
				$a_id = $a['job_id'] ?? '';
				$b_id = $b['job_id'] ?? '';
				if ($a_id === '' && $b_id === '') return 0;
				if ($a_id === '') return 1;
				if ($b_id === '') return -1;
				if (function_exists('moores_sentra_compare_sort_value')) {
					return moores_sentra_compare_sort_value($a_id, $b_id);
				}
				return strnatcasecmp($a_id, $b_id);
			});

			$job_cards = array_slice($job_cards, 0, 12);

			foreach ($job_cards as $job) {
				$payload_items = [];
				foreach (array_slice($job['items'], 0, 24) as $item) {
					$media_type = $mc_is_video($item) ? 'video' : 'image';
					$payload_items[] = [
						'src' => $item['src'] ?? '',
						'title' => $item['title'] ?? '',
						'caption' => $item['caption'] ?? '',
						'process' => $item['process'] ?? '',
						'part' => $item['part'] ?? '',
						'job_id' => $item['job_id'] ?? '',
						'media_type' => $media_type,
						'is_featured' => $item['is_featured'] ?? false,
					];
				}
				$jobs_payload[$job['key']] = [
					'job_id' => $job['job_id'],
					'is_featured' => $job['is_featured'],
					'items' => $payload_items,
				];
			}
		}
		?>
		<?php if (!empty($job_cards)) : ?>
			<p class="lead">Jobs are grouped by build. The front image is the final product when available.</p>
			<div style="margin-top: var(--sp-30);" class="gallery-grid gallery-job-grid" id="moores-gallery-grid">
				<?php
				$span_pattern = [6, 3, 3, 4, 4, 4, 6, 3, 3, 4, 4, 4];
				?>
				<?php foreach ($job_cards as $index => $job) : ?>
					<?php
					$cover = $job['cover'];
					$title = $cover['title'] ?: ($cover['caption'] ?: "Moore's CustomZ");
					$caption = $cover['caption'] ?: '';
					$job_label = !empty($job['job_id']) ? 'Job ' . $job['job_id'] : 'Gallery Highlight';
					$part_label = !empty($cover['part']) ? 'Part ' . $cover['part'] : '';
					$process_label = !empty($cover['process']) ? ucwords(str_replace(['_', '-'], ' ', $cover['process'])) : '';
					$chips = array_filter([$part_label, $process_label, $job_label]);
					if (!$chips && !empty($cover['tag'])) $chips[] = $cover['tag'];
					$span_value = $job['is_featured'] ? 6 : ($span_pattern[$index % count($span_pattern)] ?? 4);
					$span = 'g-span-' . $span_value;
					$size_class = $span_value >= 6 ? 'is-large' : ($span_value <= 3 ? 'is-small' : 'is-medium');
					?>
					<div class="g-item has-meta g-job-card <?php echo esc_attr($span); ?> <?php echo esc_attr($size_class); ?> <?php echo $job['is_featured'] ? 'is-featured' : ''; ?> <?php echo $job['cover_is_video'] ? 'is-video' : ''; ?>"
						data-job-key="<?php echo esc_attr($job['key']); ?>"
						data-full="<?php echo esc_url($cover['src']); ?>"
						data-media-type="<?php echo $job['cover_is_video'] ? 'video' : 'image'; ?>"
						data-title="<?php echo esc_attr($title); ?>">
						<?php if ($job['cover_is_video']) : ?>
							<video src="<?php echo esc_url($cover['src']); ?>" muted playsinline preload="metadata"></video>
						<?php else : ?>
							<img src="<?php echo esc_url($cover['src']); ?>"
								alt="<?php echo esc_attr($title); ?>"
								onerror="this.style.display='none';">
						<?php endif; ?>
						<div class="g-item-overlay">
							<div class="g-item-top">
								<div class="g-item-badges">
									<?php if ($job['is_featured']) : ?>
										<span class="g-item-badge">Featured</span>
									<?php endif; ?>
									<?php foreach ($chips as $chip) : ?>
										<span class="g-item-chip"><?php echo esc_html($chip); ?></span>
									<?php endforeach; ?>
								</div>
							</div>
							<div class="g-item-meta">
								<div class="g-item-title"><?php echo esc_html($title); ?></div>
								<?php if (!empty($caption) && $caption !== $title) : ?>
									<div class="g-item-sub"><?php echo esc_html($caption); ?></div>
								<?php endif; ?>
								<div class="g-item-sub">Tap to open • Press and hold to zoom</div>
							</div>
						</div>
					</div>
				<?php endforeach; ?>
			</div>

			<div class="mc-gallery-modal" id="mc-gallery-modal" aria-hidden="true">
				<div class="mc-gallery-modal-backdrop" data-gallery-close></div>
				<div class="mc-gallery-modal-panel" role="dialog" aria-modal="true" aria-labelledby="mc-gallery-modal-title">
					<button class="mc-gallery-close" type="button" data-gallery-close>Close</button>
					<div class="mc-gallery-modal-head">
						<div class="kicker">Build</div>
						<h3 id="mc-gallery-modal-title">Gallery</h3>
						<p class="lead" id="mc-gallery-modal-sub">Tap any image to view full size.</p>
					</div>
					<div class="mc-gallery-modal-summary" id="mc-gallery-modal-summary"></div>
					<div class="mc-gallery-modal-grid" id="mc-gallery-modal-grid"></div>
				</div>
			</div>

			<div class="mc-gallery-zoom" id="mc-gallery-zoom" aria-hidden="true">
				<div class="mc-gallery-modal-backdrop" data-zoom-close></div>
				<div class="mc-gallery-zoom-panel" role="dialog" aria-modal="true" aria-labelledby="mc-gallery-zoom-label">
					<div class="mc-gallery-zoom-toolbar">
						<div class="mc-gallery-zoom-label" id="mc-gallery-zoom-label">Image</div>
						<label class="mc-gallery-zoom-range">
							<span>Zoom</span>
							<input type="range" min="1" max="3" step="0.05" value="1" id="mc-gallery-zoom-range">
						</label>
						<button class="mc-gallery-close" type="button" data-zoom-close>Close</button>
					</div>
					<div class="mc-gallery-zoom-body">
						<div class="mc-gallery-zoom-stage" id="mc-gallery-zoom-stage">
							<img id="mc-gallery-zoom-image" src="" alt="">
							<video id="mc-gallery-zoom-video" playsinline controls preload="metadata"></video>
						</div>
					</div>
				</div>
			</div>

			<script>
			(() => {
				const jobs = <?php echo wp_json_encode($jobs_payload); ?>;
				const grid = document.getElementById('moores-gallery-grid');
				if (!grid) return;

				const modal = document.getElementById('mc-gallery-modal');
				const modalGrid = document.getElementById('mc-gallery-modal-grid');
				const modalTitle = document.getElementById('mc-gallery-modal-title');
				const modalSub = document.getElementById('mc-gallery-modal-sub');
				const modalSummary = document.getElementById('mc-gallery-modal-summary');

				const zoomModal = document.getElementById('mc-gallery-zoom');
				const zoomImage = document.getElementById('mc-gallery-zoom-image');
				const zoomLabel = document.getElementById('mc-gallery-zoom-label');
				const zoomRange = document.getElementById('mc-gallery-zoom-range');
				const zoomStage = document.getElementById('mc-gallery-zoom-stage');
				const zoomVideo = document.getElementById('mc-gallery-zoom-video');
				const zoomPanel = document.querySelector('.mc-gallery-zoom-panel');

				const zoomState = {
					mode: 'image',
					scale: 1,
					tx: 0,
					ty: 0,
					baseWidth: 0,
					baseHeight: 0,
					dragging: false,
					dragStartX: 0,
					dragStartY: 0,
					usingPointer: false,
					dragPointerId: null,
					disablePointer: false,
				};
				const activePointers = new Map();
				const pinchState = {
					active: false,
					startDist: 0,
					startScale: 1,
					startMidX: 0,
					startMidY: 0,
					startTx: 0,
					startTy: 0,
				};

				const getPointerList = () => Array.from(activePointers.values());
				const getDistance = (a, b) => Math.hypot(a.x - b.x, a.y - b.y);
				const getMidpoint = (a, b) => ({ x: (a.x + b.x) / 2, y: (a.y + b.y) / 2 });

				const syncBodyModalState = () => {
					const anyOpen = document.querySelector('.mc-gallery-modal.is-open, .mc-gallery-zoom.is-open');
					document.body.classList.toggle('mc-modal-open', Boolean(anyOpen));
				};

				const setModalOpen = (target, open) => {
					if (!target) return;
					target.classList.toggle('is-open', open);
					target.setAttribute('aria-hidden', open ? 'false' : 'true');
					syncBodyModalState();
				};

				const applyZoomTransform = () => {
					if (zoomState.mode !== 'image') return;
					zoomImage.style.transform = `translate(${zoomState.tx}px, ${zoomState.ty}px) scale(${zoomState.scale})`;
				};

				const clampTranslation = () => {
					if (zoomState.mode !== 'image') return;
					if (!zoomState.baseWidth || !zoomState.baseHeight) return;
					if (zoomState.scale <= 1.001) {
						zoomState.scale = 1;
						zoomState.tx = 0;
						zoomState.ty = 0;
						return;
					}
					const rect = zoomStage.getBoundingClientRect();
					const scaledWidth = zoomState.baseWidth * zoomState.scale;
					const scaledHeight = zoomState.baseHeight * zoomState.scale;
					const overflowX = Math.max(0, (scaledWidth - rect.width) / 2);
					const overflowY = Math.max(0, (scaledHeight - rect.height) / 2);
					const slackFactor = Math.max(0, zoomState.scale - 1);
					const slackX = rect.width * 0.04 * slackFactor;
					const slackY = rect.height * 0.04 * slackFactor;
					const maxX = overflowX + slackX;
					const maxY = overflowY + slackY;
					zoomState.tx = Math.max(-maxX, Math.min(maxX, zoomState.tx));
					zoomState.ty = Math.max(-maxY, Math.min(maxY, zoomState.ty));
				};

				const refreshZoomMetrics = () => {
					if (zoomState.mode !== 'image') return;
					const rect = zoomStage.getBoundingClientRect();
					const naturalWidth = zoomImage.naturalWidth || 0;
					const naturalHeight = zoomImage.naturalHeight || 0;
					if (!naturalWidth || !naturalHeight || !rect.width || !rect.height) return;
					const ratio = naturalWidth / naturalHeight;
					let baseWidth = rect.width;
					let baseHeight = rect.height;
					if (rect.width / rect.height > ratio) {
						baseHeight = rect.height;
						baseWidth = baseHeight * ratio;
					} else {
						baseWidth = rect.width;
						baseHeight = baseWidth / ratio;
					}
					zoomState.baseWidth = baseWidth;
					zoomState.baseHeight = baseHeight;
					zoomImage.style.width = `${baseWidth}px`;
					zoomImage.style.height = `${baseHeight}px`;
					clampTranslation();
					applyZoomTransform();
				};

				const openZoom = (src, label, type = 'image') => {
					if (!src) return;
					zoomState.mode = type === 'video' ? 'video' : 'image';
					zoomPanel?.classList.toggle('is-video', zoomState.mode === 'video');
					zoomStage?.classList.toggle('is-video', zoomState.mode === 'video');
					activePointers.clear();
					pinchState.active = false;
					zoomState.dragging = false;
					zoomState.dragPointerId = null;
					if (zoomState.mode === 'video') {
						zoomRange.value = 1;
						zoomImage.style.display = 'none';
						zoomVideo.style.display = 'block';
						zoomVideo.src = src;
						zoomVideo.load();
					} else {
						zoomVideo.pause();
						zoomVideo.removeAttribute('src');
						zoomVideo.load();
						zoomVideo.style.display = 'none';
						zoomImage.style.display = 'block';
						zoomState.scale = 1;
						zoomState.tx = 0;
						zoomState.ty = 0;
						zoomRange.value = 1;
						zoomImage.src = src;
						zoomImage.alt = label || 'Gallery image';
						if (zoomImage.complete) {
							refreshZoomMetrics();
						} else {
							zoomImage.onload = refreshZoomMetrics;
						}
					}
					zoomLabel.textContent = label || (zoomState.mode === 'video' ? 'Video' : 'Gallery image');
					setModalOpen(zoomModal, true);
					requestAnimationFrame(() => {
						refreshZoomMetrics();
						setTimeout(refreshZoomMetrics, 60);
					});
				};

				const closeZoom = () => {
					zoomVideo.pause();
					zoomVideo.removeAttribute('src');
					zoomVideo.load();
					activePointers.clear();
					pinchState.active = false;
					zoomState.dragging = false;
					zoomState.dragPointerId = null;
					zoomState.disablePointer = false;
					window.removeEventListener('pointermove', movePointer);
					window.removeEventListener('pointerup', endPointer);
					window.removeEventListener('pointercancel', endPointer);
					setModalOpen(zoomModal, false);
				};

				const escapeHtml = (value) => String(value ?? '')
					.replace(/&/g, '&amp;')
					.replace(/</g, '&lt;')
					.replace(/>/g, '&gt;')
					.replace(/"/g, '&quot;')
					.replace(/'/g, '&#39;');

				const compareSortToken = (value) => {
					const raw = String(value ?? '').trim();
					if (!raw) return { num: null, text: '' };
					const match = raw.match(/^(\\d+)[\\s._-]*(.*)$/);
					if (match) {
						const num = Number.parseInt(match[1], 10);
						const text = (match[2] || raw).trim();
						return { num: Number.isFinite(num) ? num : null, text: text || raw };
					}
					return { num: null, text: raw };
				};

				const compareSortValue = (a, b) => {
					const aVal = String(a ?? '').trim();
					const bVal = String(b ?? '').trim();
					if (!aVal && !bVal) return 0;
					if (!aVal) return 1;
					if (!bVal) return -1;
					const aToken = compareSortToken(aVal);
					const bToken = compareSortToken(bVal);
					if (aToken.num !== null && bToken.num !== null && aToken.num !== bToken.num) {
						return aToken.num - bToken.num;
					}
					if (aToken.num !== null && bToken.num === null) return -1;
					if (aToken.num === null && bToken.num !== null) return 1;
					return aToken.text.localeCompare(bToken.text, undefined, { numeric: true, sensitivity: 'base' });
				};

				const isFinalProcess = (item) => {
					const raw = String(item?.process ?? '').toLowerCase();
					if (!raw) return false;
					return ['final', 'finish', 'finished', 'complete', 'completed', 'delivery', 'delivered', 'done'].some((token) => raw.includes(token));
				};

				const openModal = (jobKey) => {
					const payload = jobs?.[jobKey];
					if (!payload) return;
					const jobTitle = payload.job_id ? `Job ${payload.job_id}` : 'Gallery Highlight';
					modalTitle.textContent = jobTitle;
					modalSub.textContent = `${payload.items.length} media items • Tap any image to view full size.`;
					modalGrid.innerHTML = '';
					if (modalSummary) modalSummary.innerHTML = '';

					const sortedItems = payload.items.slice().sort((a, b) => {
						const partSort = compareSortValue(a.part, b.part);
						if (partSort !== 0) return partSort;
						const procSort = compareSortValue(a.process, b.process);
						if (procSort !== 0) return procSort;
						return compareSortValue(a.title || a.caption, b.title || b.caption);
					});

					const coverItem = sortedItems.find(isFinalProcess) || sortedItems.find((item) => item.is_featured) || sortedItems[0];
					const uniqueParts = Array.from(new Set(sortedItems.map((item) => item.part).filter(Boolean)));
					const uniqueProcesses = Array.from(new Set(sortedItems.map((item) => item.process).filter(Boolean)));

					if (modalSummary && coverItem) {
						const coverTitle = coverItem.title || coverItem.caption || jobTitle;
						const coverCaption = coverItem.caption && coverItem.caption !== coverTitle ? coverItem.caption : '';
						const coverType = coverItem.media_type || 'image';
						const partsLabel = uniqueParts.length ? uniqueParts.slice(0, 6).join(' • ') : 'Parts not tagged';
						const processesLabel = uniqueProcesses.length ? uniqueProcesses.slice(0, 6).join(' • ') : 'Stages not tagged';
						const heroMedia = coverType === 'video'
							? `<video src="${escapeHtml(coverItem.src)}" muted playsinline preload="metadata"></video>`
							: `<img src="${escapeHtml(coverItem.src)}" alt="${escapeHtml(coverTitle)}">`;
						modalSummary.innerHTML = `
							<div class="mc-gallery-modal-hero" data-hero-src="${escapeHtml(coverItem.src)}" data-hero-title="${escapeHtml(coverTitle)}" data-hero-type="${escapeHtml(coverType)}">
								${heroMedia}
								<div class="mc-gallery-modal-hero-meta">
									<div class="mc-gallery-modal-chips">
										${payload.is_featured ? '<span>Featured</span>' : ''}
										${uniqueParts.length ? `<span>${escapeHtml(partsLabel)}</span>` : ''}
										${uniqueProcesses.length ? `<span>${escapeHtml(processesLabel)}</span>` : ''}
									</div>
									<div class="mc-gallery-modal-title">${escapeHtml(coverTitle)}</div>
									${coverCaption ? `<div class="mc-gallery-modal-sub">${escapeHtml(coverCaption)}</div>` : ''}
								</div>
							</div>
							<div class="mc-gallery-modal-details">
								<div class="mc-gallery-modal-stats">
									<div class="mc-gallery-stat">
										<div class="label">Media</div>
										<div class="value">${payload.items.length}</div>
									</div>
									<div class="mc-gallery-stat">
										<div class="label">Parts</div>
										<div class="value">${uniqueParts.length || '-'}</div>
									</div>
									<div class="mc-gallery-stat">
										<div class="label">Stages</div>
										<div class="value">${uniqueProcesses.length || '-'}</div>
									</div>
								</div>
								<div class="mc-gallery-modal-note">Process order: parts → build stages → job.</div>
							</div>
						`;
						const hero = modalSummary.querySelector('.mc-gallery-modal-hero');
						if (hero) {
							hero.addEventListener('click', () => {
								const src = hero.dataset.heroSrc || '';
								if (!src) return;
								openZoom(src, hero.dataset.heroTitle || jobTitle, hero.dataset.heroType || 'image');
							});
						}
					}

					const frag = document.createDocumentFragment();
					sortedItems.forEach((item) => {
						if (!item?.src) return;
						const wrapper = document.createElement('button');
						wrapper.type = 'button';
						wrapper.className = 'mc-gallery-modal-item';
						const title = item.title || item.caption || jobTitle;
						const chips = [];
						if (item.is_featured) chips.push('Featured');
						if (item.part) chips.push(`Part ${item.part}`);
						if (item.process) chips.push(item.process.replace(/[_-]/g, ' '));
						if (item.job_id) chips.push(`Job ${item.job_id}`);
						const mediaType = item.media_type || 'image';
						if (mediaType === 'video') {
							wrapper.classList.add('is-video');
						}
						const mediaHtml = mediaType === 'video'
							? `<video src="${item.src}" muted playsinline preload="metadata"></video>`
							: `<img src="${item.src}" alt="${title.replace(/\"/g, '&quot;')}">`;
						wrapper.innerHTML = `
							${mediaHtml}
							<div class="mc-gallery-modal-meta">
								${chips.length ? `<div class="mc-gallery-modal-chips">${chips.map((chip) => `<span>${chip}</span>`).join('')}</div>` : ''}
								<div class="mc-gallery-modal-title">${title}</div>
								${item.caption && item.caption !== title ? `<div class="mc-gallery-modal-sub">${item.caption}</div>` : ''}
							</div>
						`;
						wrapper.addEventListener('click', () => {
							if (wrapper.dataset.longPress === '1') {
								wrapper.dataset.longPress = '0';
								return;
							}
							openZoom(item.src, title, item.media_type || 'image');
						});
						attachLongPress(wrapper, () => ({ src: item.src, label: title, type: item.media_type || 'image' }));
						frag.appendChild(wrapper);
					});
					modalGrid.appendChild(frag);
					setModalOpen(modal, true);
				};

				const closeModal = () => setModalOpen(modal, false);

				const attachLongPress = (node, payloadFn) => {
					let timer = null;
					const clear = () => {
						if (timer) {
							clearTimeout(timer);
							timer = null;
						}
					};
					const start = (event) => {
						if (event.type === 'mousedown' && event.button !== 0) return;
						clear();
						node.dataset.longPress = '0';
						timer = setTimeout(() => {
							node.dataset.longPress = '1';
							const payload = payloadFn();
							if (payload?.src) openZoom(payload.src, payload.label || '', payload.type || 'image');
						}, 420);
					};
					node.addEventListener('pointerdown', start);
					node.addEventListener('pointerup', clear);
					node.addEventListener('pointerleave', clear);
					node.addEventListener('pointercancel', clear);
					node.addEventListener('contextmenu', (event) => {
						if (node.dataset.longPress === '1') event.preventDefault();
					});
				};

				grid.querySelectorAll('.g-job-card').forEach((card) => {
					attachLongPress(card, () => ({
						src: card.dataset.full,
						label: card.dataset.title || '',
						type: card.dataset.mediaType || 'image'
					}));
					card.addEventListener('click', () => {
						if (card.dataset.longPress === '1') {
							card.dataset.longPress = '0';
							return;
						}
						openModal(card.dataset.jobKey);
					});
				});

				modal?.querySelectorAll('[data-gallery-close]').forEach((btn) => {
					btn.addEventListener('click', closeModal);
				});
				zoomModal?.querySelectorAll('[data-zoom-close]').forEach((btn) => {
					btn.addEventListener('click', closeZoom);
				});
				zoomRange?.addEventListener('input', () => {
					const scale = Math.max(1, parseFloat(zoomRange.value || '1'));
					zoomState.scale = scale;
					if (scale === 1) {
						zoomState.tx = 0;
						zoomState.ty = 0;
					}
					clampTranslation();
					applyZoomTransform();
				});
				const beginPointer = (event) => {
					if (zoomState.disablePointer) return;
					if (zoomState.mode !== 'image') return;
					if (event.pointerType === 'mouse' && event.button !== 0) return;
					event.preventDefault();
					zoomState.usingPointer = true;
					activePointers.set(event.pointerId, { x: event.clientX, y: event.clientY });
					try {
						zoomStage?.setPointerCapture(event.pointerId);
					} catch (e) {}

					const pointers = getPointerList();
					if (pointers.length === 2) {
						pinchState.active = true;
						pinchState.startDist = getDistance(pointers[0], pointers[1]) || 1;
						pinchState.startScale = zoomState.scale;
						const mid = getMidpoint(pointers[0], pointers[1]);
						pinchState.startMidX = mid.x;
						pinchState.startMidY = mid.y;
						pinchState.startTx = zoomState.tx;
						pinchState.startTy = zoomState.ty;
						zoomState.dragging = false;
						zoomState.dragPointerId = null;
						zoomStage?.classList.add('is-dragging');
						window.addEventListener('pointermove', movePointer, { passive: false });
						window.addEventListener('pointerup', endPointer);
						window.addEventListener('pointercancel', endPointer);
						return;
					}

					if (zoomState.scale > 1.001 && pointers.length === 1) {
						event.preventDefault();
						zoomState.dragging = true;
						zoomState.dragStartX = event.clientX - zoomState.tx;
						zoomState.dragStartY = event.clientY - zoomState.ty;
						zoomState.dragPointerId = event.pointerId;
						zoomStage?.classList.add('is-dragging');
						window.addEventListener('pointermove', movePointer, { passive: false });
						window.addEventListener('pointerup', endPointer);
						window.addEventListener('pointercancel', endPointer);
					}
				};

				const movePointer = (event) => {
					if (zoomState.disablePointer) return;
					if (zoomState.mode !== 'image') return;
					if (event.pointerType === 'mouse' && !event.buttons) return;
					if (!activePointers.has(event.pointerId)) return;
					activePointers.set(event.pointerId, { x: event.clientX, y: event.clientY });

					const pointers = getPointerList();
					if (pointers.length === 2) {
						event.preventDefault();
						const dist = getDistance(pointers[0], pointers[1]) || 1;
						const scale = Math.max(1, Math.min(3, (pinchState.startScale || 1) * (dist / (pinchState.startDist || 1))));
						zoomState.scale = scale;
						zoomRange.value = String(scale);
						const mid = getMidpoint(pointers[0], pointers[1]);
						zoomState.tx = pinchState.startTx + (mid.x - pinchState.startMidX);
						zoomState.ty = pinchState.startTy + (mid.y - pinchState.startMidY);
						clampTranslation();
						applyZoomTransform();
						return;
					}

					if (!zoomState.dragging && zoomState.scale > 1.001 && pointers.length === 1) {
						zoomState.dragging = true;
						zoomState.dragStartX = event.clientX - zoomState.tx;
						zoomState.dragStartY = event.clientY - zoomState.ty;
						zoomState.dragPointerId = event.pointerId;
					}

					if (zoomState.dragging && pointers.length === 1 && (zoomState.dragPointerId === null || zoomState.dragPointerId === event.pointerId)) {
						event.preventDefault();
						zoomState.tx = event.clientX - zoomState.dragStartX;
						zoomState.ty = event.clientY - zoomState.dragStartY;
						clampTranslation();
						applyZoomTransform();
					}
				};

				const endPointer = (event) => {
					if (zoomState.disablePointer) return;
					activePointers.delete(event.pointerId);
					if (activePointers.size < 2) {
						pinchState.active = false;
					}
					if (activePointers.size === 1 && zoomState.scale > 1.001) {
						const remainingEntry = activePointers.entries().next();
						if (!remainingEntry.done) {
							const [remainingId, remaining] = remainingEntry.value;
							zoomState.dragging = true;
							zoomState.dragStartX = remaining.x - zoomState.tx;
							zoomState.dragStartY = remaining.y - zoomState.ty;
							zoomState.dragPointerId = remainingId;
						}
					} else if (activePointers.size === 0) {
						zoomState.dragging = false;
						zoomStage?.classList.remove('is-dragging');
						zoomState.usingPointer = false;
						zoomState.dragPointerId = null;
						window.removeEventListener('pointermove', movePointer);
						window.removeEventListener('pointerup', endPointer);
						window.removeEventListener('pointercancel', endPointer);
					}
					if (event?.pointerId !== undefined) {
						try {
							zoomStage?.releasePointerCapture(event.pointerId);
						} catch (e) {}
					}
				};

				const handleWheel = (event) => {
					if (zoomState.mode !== 'image') return;
					event.preventDefault();
					const oldScale = zoomState.scale || 1;
					const direction = event.deltaY < 0 ? 1 : -1;
					const step = 0.15;
					let nextScale = oldScale + direction * step;
					nextScale = Math.max(1, Math.min(3, nextScale));
					if (nextScale === oldScale) return;
					const rect = zoomStage.getBoundingClientRect();
					const offsetX = event.clientX - rect.left - rect.width / 2;
					const offsetY = event.clientY - rect.top - rect.height / 2;
					const ratio = nextScale / oldScale;
					zoomState.tx = zoomState.tx + offsetX * (1 - ratio);
					zoomState.ty = zoomState.ty + offsetY * (1 - ratio);
					zoomState.scale = nextScale;
					zoomRange.value = String(nextScale);
					clampTranslation();
					applyZoomTransform();
				};

				zoomStage?.addEventListener('pointerdown', beginPointer);
				zoomStage?.addEventListener('pointermove', movePointer);
				zoomStage?.addEventListener('pointerup', endPointer);
				zoomStage?.addEventListener('pointercancel', endPointer);
				zoomStage?.addEventListener('wheel', handleWheel, { passive: false });

				const syncTouchPointers = (touches) => {
					activePointers.clear();
					for (const touch of Array.from(touches || [])) {
						activePointers.set(touch.identifier, { x: touch.clientX, y: touch.clientY });
					}
				};

				const beginTouch = (event) => {
					if (zoomState.mode !== 'image') return;
					zoomState.disablePointer = true;
					zoomState.usingPointer = true;
					syncTouchPointers(event.touches);
					if (!activePointers.size) return;
					event.preventDefault();
					const pointers = getPointerList();
					if (pointers.length === 2) {
						pinchState.active = true;
						pinchState.startDist = getDistance(pointers[0], pointers[1]) || 1;
						pinchState.startScale = zoomState.scale;
						const mid = getMidpoint(pointers[0], pointers[1]);
						pinchState.startMidX = mid.x;
						pinchState.startMidY = mid.y;
						pinchState.startTx = zoomState.tx;
						pinchState.startTy = zoomState.ty;
						zoomState.dragging = false;
						zoomState.dragPointerId = null;
						zoomStage?.classList.add('is-dragging');
						return;
					}
					if (zoomState.scale > 1.001 && pointers.length === 1) {
						const touch = pointers[0];
						zoomState.dragging = true;
						zoomState.dragStartX = touch.x - zoomState.tx;
						zoomState.dragStartY = touch.y - zoomState.ty;
						zoomState.dragPointerId = event.touches[0]?.identifier ?? null;
						zoomStage?.classList.add('is-dragging');
					}
				};

				const moveTouch = (event) => {
					if (zoomState.mode !== 'image') return;
					if (!activePointers.size && !(event.touches && event.touches.length)) return;
					event.preventDefault();
					syncTouchPointers(event.touches);
					const pointers = getPointerList();
					if (pointers.length === 2) {
						const dist = getDistance(pointers[0], pointers[1]) || 1;
						const scale = Math.max(1, Math.min(3, (pinchState.startScale || 1) * (dist / (pinchState.startDist || 1))));
						zoomState.scale = scale;
						zoomRange.value = String(scale);
						const mid = getMidpoint(pointers[0], pointers[1]);
						zoomState.tx = pinchState.startTx + (mid.x - pinchState.startMidX);
						zoomState.ty = pinchState.startTy + (mid.y - pinchState.startMidY);
						clampTranslation();
						applyZoomTransform();
						return;
					}
					if (!zoomState.dragging && zoomState.scale > 1.001 && pointers.length === 1) {
						const touch = pointers[0];
						zoomState.dragging = true;
						zoomState.dragStartX = touch.x - zoomState.tx;
						zoomState.dragStartY = touch.y - zoomState.ty;
					}
					if (zoomState.dragging && pointers.length === 1) {
						const touch = pointers[0];
						zoomState.tx = touch.x - zoomState.dragStartX;
						zoomState.ty = touch.y - zoomState.dragStartY;
						clampTranslation();
						applyZoomTransform();
					}
				};

				const endTouch = (event) => {
					syncTouchPointers(event.touches);
					if (activePointers.size < 2) {
						pinchState.active = false;
					}
					if (activePointers.size === 1 && zoomState.scale > 1.001) {
						const remaining = getPointerList()[0];
						if (remaining) {
							zoomState.dragging = true;
							zoomState.dragStartX = remaining.x - zoomState.tx;
							zoomState.dragStartY = remaining.y - zoomState.ty;
							zoomState.dragPointerId = event.touches[0]?.identifier ?? null;
						}
					} else if (activePointers.size === 0) {
						zoomState.dragging = false;
						zoomStage?.classList.remove('is-dragging');
						zoomState.usingPointer = false;
						zoomState.dragPointerId = null;
						zoomState.disablePointer = false;
					}
				};

				zoomStage?.addEventListener('touchstart', beginTouch, { passive: false });
				zoomStage?.addEventListener('touchmove', moveTouch, { passive: false });
				zoomStage?.addEventListener('touchend', endTouch);
				zoomStage?.addEventListener('touchcancel', endTouch);

				const beginMouseDrag = (event) => {
					if (zoomState.usingPointer) return;
					if (zoomState.mode !== 'image') return;
					if (event.button !== 0) return;
					if (zoomState.scale <= 1.001) return;
					event.preventDefault();
					zoomState.dragging = true;
					zoomState.dragStartX = event.clientX - zoomState.tx;
					zoomState.dragStartY = event.clientY - zoomState.ty;
					zoomStage?.classList.add('is-dragging');
					window.addEventListener('mousemove', moveMouseDrag);
					window.addEventListener('mouseup', endMouseDrag);
				};

				const moveMouseDrag = (event) => {
					if (!zoomState.dragging) return;
					event.preventDefault();
					zoomState.tx = event.clientX - zoomState.dragStartX;
					zoomState.ty = event.clientY - zoomState.dragStartY;
					clampTranslation();
					applyZoomTransform();
				};

				const endMouseDrag = () => {
					zoomState.dragging = false;
					zoomStage?.classList.remove('is-dragging');
					window.removeEventListener('mousemove', moveMouseDrag);
					window.removeEventListener('mouseup', endMouseDrag);
				};

				zoomStage?.addEventListener('mousedown', beginMouseDrag);
				window.addEventListener('resize', () => {
					if (zoomModal?.classList.contains('is-open')) refreshZoomMetrics();
				});
				document.addEventListener('keydown', (event) => {
					if (event.key === 'Escape') {
						closeZoom();
						closeModal();
					}
				});
			})();
			</script>
		<?php else : ?>
			<?php
			$cfg = function_exists('moores_sentra_config') ? moores_sentra_config() : [];
			$tenant_id = $cfg['tenant_id'] ?? 'moorescustomz';
			$gallery_base = !empty($cfg['media_base']) ? $cfg['media_base'] : 'https://sentrasys.dev';
			?>
			<div style="margin-top: var(--sp-30);" class="gallery-grid" id="moores-gallery-remote" data-tenant="<?php echo esc_attr($tenant_id); ?>" data-base="<?php echo esc_attr($gallery_base); ?>" data-ajax="<?php echo esc_url(admin_url('admin-ajax.php')); ?>"></div>
			<script>
			(() => {
				const grid = document.getElementById('moores-gallery-remote');
				if (!grid) return;
				const tenant = grid.dataset.tenant || 'moorescustomz';
				const base = (grid.dataset.base || 'https://sentrasys.dev').replace(/\/+$/, '');
				const ajaxUrl = grid.dataset.ajax || '';
				const body = new FormData();
				body.set('action', 'moores_sentra_proxy');
				body.set('resource', 'gallery');
				body.set('method', 'GET');
				body.set('query', JSON.stringify({ per_page: 9 }));

				fetch(ajaxUrl, {
					method: 'POST',
					credentials: 'same-origin',
					body
				})
					.then(res => res.json())
					.then(data => {
						const payload = data?.data ?? data;
						const items = Array.isArray(payload?.items) ? payload.items : (Array.isArray(payload?.gallery) ? payload.gallery : []);
					if (!items.length) {
						grid.innerHTML = '<p class="lead">Gallery updates are in progress. Check back soon or contact us for current work.</p>';
						return;
					}
						const frag = document.createDocumentFragment();
						items.slice(0, 9).forEach((item, index) => {
							const span = index < 2 ? 'g-span-6' : 'g-span-4';
							const src = item.media_url || item.thumbnail_url || item.image_path || item.thumbnail_path || item.cover_image || item.file_path || '';
							if (!src) return;
						const imgSrc = src.startsWith('http') ? src : `${base}/${src.replace(/^\/+/, '')}`;
						const alt = item.caption || item.title || "Moore's Customz work";
							const wrapper = document.createElement('div');
							wrapper.className = `g-item ${span}`;
							const img = document.createElement('img');
							img.src = imgSrc;
							img.alt = alt;
							wrapper.appendChild(img);
							frag.appendChild(wrapper);
						});
						grid.innerHTML = '';
						grid.appendChild(frag);
					})
					.catch(() => {
					grid.innerHTML = '<p class="lead">Gallery updates are in progress. Check back soon or contact us for current work.</p>';
				});
			})();
			</script>
		<?php endif; ?>
	</div>
</section>

<!-- NEW: Partner Shops Network -->
<section class="section" id="partners" style="background: rgba(255,255,255,0.01); border-top: 1px solid rgba(255,255,255,0.06); border-bottom: 1px solid rgba(255,255,255,0.06);">
	<div class="container-wide">
		<div class="kicker">Trusted Network</div>
		<h2>Partner Shops & Specialists</h2>
		<p class="lead">
			Our partner list highlights shops and storefronts that carry Moore's Customz work. These are places you can see displays,
			commission projects, or purchase pieces with our artwork.
		</p>

		<?php $partner_shops = function_exists('moores_sentra_get_partner_shops') ? moores_sentra_get_partner_shops(6) : []; ?>
		<?php if (!empty($partner_shops)) : ?>
			<div style="margin-top: var(--sp-40);" class="cards">
				<?php foreach ($partner_shops as $shop) : ?>
					<?php
					$address_parts = [];
					if (!empty($shop['address'])) $address_parts[] = $shop['address'];
					$city_line = '';
					if (!empty($shop['city'])) $city_line .= $shop['city'];
					if (!empty($shop['state'])) $city_line .= ($city_line ? ', ' : '') . $shop['state'];
					if (!empty($shop['zip'])) $city_line .= ($city_line ? ' ' : '') . $shop['zip'];
					if ($city_line) $address_parts[] = $city_line;
					$address_line = implode(', ', $address_parts);

					$phone_raw = !empty($shop['phone']) ? preg_replace('/[^0-9+]/', '', $shop['phone']) : '';
					?>
					<div class="card">
						<h3><?php echo esc_html($shop['title']); ?></h3>
						<?php if (!empty($shop['type'])) : ?>
							<div class="badge" style="margin-bottom: 10px;"><?php echo esc_html(strtoupper($shop['type'])); ?></div>
						<?php endif; ?>
						<?php if (!empty($shop['description'])) : ?>
							<p><?php echo esc_html($shop['description']); ?></p>
						<?php endif; ?>
						<?php if (!empty($address_line)) : ?>
							<p style="color: var(--muted); margin-bottom: 6px;">Address: <?php echo esc_html($address_line); ?></p>
						<?php endif; ?>
						<?php if (!empty($shop['phone'])) : ?>
							<p style="color: var(--muted); margin-bottom: 6px;">
								Phone: <?php if ($phone_raw) : ?><a class="link" href="tel:<?php echo esc_attr($phone_raw); ?>"><?php echo esc_html($shop['phone']); ?></a><?php else : ?><?php echo esc_html($shop['phone']); ?><?php endif; ?>
							</p>
						<?php endif; ?>
						<?php if (!empty($shop['email'])) : ?>
							<p style="color: var(--muted); margin-bottom: 6px;">
								Email: <a class="link" href="mailto:<?php echo esc_attr($shop['email']); ?>"><?php echo esc_html($shop['email']); ?></a>
							</p>
						<?php endif; ?>
						<?php if (!empty($shop['website'])) : ?>
							<p><a class="link" href="<?php echo esc_url($shop['website']); ?>" target="_blank" rel="noopener">Visit site</a></p>
						<?php endif; ?>
					</div>
				<?php endforeach; ?>
			</div>
		<?php else : ?>
			<p class="lead" style="margin-top: var(--sp-40);">Partner roster is being finalized. Contact us for referrals.</p>
		<?php endif; ?>

		<div style="margin-top: var(--sp-40); text-align: center;">
			<p style="color: var(--muted-2); font-size: 0.95rem; margin: 0;">
				Interested in carrying Moore's Customz or adding a display? Contact us to become a partner.
			</p>
		</div>
	</div>
</section>

<?php get_footer(); ?>
